﻿using System;
using System.IO;

namespace CopyStream
{
    class Program
    {
        // Listing 11-46. Kopiowanie danych z jednego strumienia do drugiego.
        private static void WriteTo(Stream source, Stream target, int bufferLength)
        {
            bufferLength = Math.Max(100, bufferLength);
            var buffer = new byte[bufferLength];
            int bytesRead;
            do
            {
                bytesRead = source.Read(buffer, 0, buffer.Length);
                if (bytesRead != 0)
                {
                    target.Write(buffer, 0, bytesRead);
                }
            } while (bytesRead > 0);
        }

        static void Main(string[] args)
        {
        }
    }
}
